
// DeviceEnumerationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DeviceEnumeration.h"
#include "DeviceEnumerationDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CDeviceEnumerationDlg dialog


CDeviceEnumerationDlg::CDeviceEnumerationDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CDeviceEnumerationDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDeviceEnumerationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_CAPTURE_DEVICE_ENUMERATION, m_listboxCaptureDevice);
	DDX_Control(pDX, IDC_LIST_CAPTURE_DEVICE_NAME_ENUMERATION, m_listboxCaptureDeviceName);
	DDX_Control(pDX, IDC_LIST_SOUNDCARD_ENUMERATION, m_listboxSoundCard);
	DDX_Control(pDX, IDC_LIST_CAMERA_ENUMERATION, m_listboxCamera);
}

BEGIN_MESSAGE_MAP(CDeviceEnumerationDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDOK, &CDeviceEnumerationDlg::OnBnClickedOk)
END_MESSAGE_MAP()


// CDeviceEnumerationDlg message handlers

BOOL CDeviceEnumerationDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

int CDeviceEnumerationDlg::HexToInt( char c )
{
        int first = c / 16 - 3;		//    1st is dec 48 = char 0
        int second = c % 16;	//      10 in 1st16  5 in 2nd 16

        // decimal code of ascii char 0-9:48-57  A-E: 65-69
        // omit dec 58-64:  :,;,<,=,>,?,@
        // map first or second 16 range to 0-9 or 10-15
		//
        int result = ( first * 10 ) + second; 

        if(result > 9) result--;

        return result;
}

int CDeviceEnumerationDlg::HexToAscii( char c, char d )
{
        int high = HexToInt( c ) * 16;

        int low = HexToInt( d );

        return high + low;
}

void CDeviceEnumerationDlg::OnDestroy() 
{
	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDeviceEnumerationDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDeviceEnumerationDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CDeviceEnumerationDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	
	m_listboxCaptureDevice.ResetContent();

	m_listboxCaptureDeviceName.ResetContent();

	m_listboxSoundCard.ResetContent();

	m_listboxCamera.ResetContent();

	// To enumerate all capture devices on the platform
	//
	ULONGLONG		* p_video_device_list = NULL ;

	ULONGLONG		* p_video_encoder_device_list = NULL ;

	ULONGLONG		* p_audio_device_list = NULL ;

	ULONGLONG		* p_audio_encoder_device_list = NULL ;

	ULONG					n_video_device_list_size = 0 ;

	ULONG					n_video_encoder_device_list_size = 0 ;

	ULONG					n_audio_device_list_size = 0 ;

	ULONG					n_audio_encoder_device_list_size = 0 ;

	BOOL						bSuccess = FALSE;

	OutputDebugString( "AMESDK_CAPTURE_DEVICE_ENUMERATION \n" );

	bSuccess = AMESDK_CAPTURE_DEVICE_ENUMERATION ( &p_video_device_list,

																										 &n_video_device_list_size,

																										 &p_video_encoder_device_list,

																										 &n_video_encoder_device_list_size,

																										 &p_audio_device_list,

																										 &n_audio_device_list_size,

																										 &p_audio_encoder_device_list,

																										 &n_audio_encoder_device_list_size );

	char pszOutDebug[ 256 ] = {0};	
	 
	for ( ULONG i = 0 ; i < n_video_device_list_size ; i++ ) {

		sprintf_s( pszOutDebug, "Live#%02x = 0x%llX\n", i,  p_video_device_list[ i ] );

		m_listboxCaptureDevice.AddString( pszOutDebug );

		OutputDebugString( pszOutDebug );
	}

	for ( ULONG i = 0 ; i < n_video_encoder_device_list_size ; i++ ) {

		sprintf_s( pszOutDebug, "Video Encoder#%02x = 0x%llX\n", i,  p_video_encoder_device_list[ i ] );	

		m_listboxCaptureDevice.AddString( pszOutDebug );

		OutputDebugString( pszOutDebug );
	}

	for ( ULONG i = 0 ; i < n_audio_device_list_size ; i++ ) {

		sprintf_s( pszOutDebug, "Audio#%02x = 0x%llX\n", i,  p_audio_device_list[ i ] );	

		m_listboxCaptureDevice.AddString( pszOutDebug );

		OutputDebugString( pszOutDebug );
	}

	for ( ULONG i = 0 ; i < n_audio_encoder_device_list_size ; i++ ) {

		sprintf_s( pszOutDebug, "Audio Encoder#%02x = 0x%llX\n", i,  p_audio_encoder_device_list[ i ] );	

		m_listboxCaptureDevice.AddString( pszOutDebug );

		OutputDebugString( pszOutDebug );
	}

	OutputDebugString( "AMESDK_CAPTURE_DEVICE_NAME_ENUMERATION \n" );

	bSuccess = FALSE;

	char pszHexString[ 20 ] = {0};

	char pszASCIIChar[ 6 ] = {0};

	char pszDevName[ 20 ] = {0};

	bSuccess = AMESDK_CAPTURE_DEVICE_NAME_ENUMERATION ( &p_video_device_list,

																													  &n_video_device_list_size,

																													  &p_video_encoder_device_list,

																													  &n_video_encoder_device_list_size,

																													  &p_audio_device_list,

																													  &n_audio_device_list_size,

																													  &p_audio_encoder_device_list,

																													  &n_audio_encoder_device_list_size );		

	int nHexStringLen = 0;

	CString strDeviceName, str1, str2, str3;

	const char * pszDev;

	int nIndex = 0;

	char szbuf = 0;

	for ( ULONG i = 0 ; i < n_video_device_list_size ; i++ ) {		

		sprintf_s( pszHexString, "%llX", p_video_device_list[ i ]  );

		strDeviceName = pszHexString;

		str1= strDeviceName.Left( 4 );         // EX: DC

		str2 = strDeviceName.Mid( 4, 4 );    // EX: 1150

		str3 = strDeviceName.Mid( 10, 6 );    // EX: USB

		// FOR STRING 1
		//
		if ( str1.GetLength() == 4 )
		{
			pszDev = str1;

			for( nIndex = 0 ; nIndex < 4 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}

		// FOR STRING 2
		//
		if ( str2.GetLength() == 4 )
		{
			sprintf_s(  pszASCIIChar, "%s ", str2 );

			strcat_s( pszDevName, 20, pszASCIIChar );
		}

		// FOR STRING 3
		//
		if ( str3.GetLength() == 6 )
		{
			pszDev = str3;

			for( nIndex = 0 ; nIndex < 6 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}	

		sprintf_s( pszOutDebug, "Live#%02x , 0x%llX, Device Name : %s \n", i,  p_video_device_list[ i ],  pszDevName );

		m_listboxCaptureDeviceName.AddString( pszOutDebug );

		memset( pszDevName, 0, 20 );

		OutputDebugString( pszOutDebug );		
	}	

	for ( ULONG i = 0 ; i < n_video_encoder_device_list_size ; i++ ) {		

		sprintf_s( pszHexString, "%llX", p_video_encoder_device_list[ i ]  );

		strDeviceName = pszHexString;

		str1= strDeviceName.Left( 4 );         // EX: DC

		str2 = strDeviceName.Mid( 4, 4 );    // EX: 1150

		str3 = strDeviceName.Mid( 10, 6 );    // EX: USB

		// FOR STRING 1
		//
		if ( str1.GetLength() == 4 )
		{
			pszDev = str1;

			for( nIndex = 0 ; nIndex < 4 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}

		// FOR STRING 2
		//
		if ( str2.GetLength() == 4 )
		{
			sprintf_s(  pszASCIIChar, "%s ", str2 );

			strcat_s( pszDevName, 20, pszASCIIChar );
		}

		// FOR STRING 3
		//
		if ( str3.GetLength() == 6 )
		{
			pszDev = str3;

			for( nIndex = 0 ; nIndex < 6 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}	

		sprintf_s( pszOutDebug, "Video Encoder#%02x , 0x%llX, Device Name : %s, Analog Encoder \n", i,  p_video_encoder_device_list[ i ],  pszDevName );

		m_listboxCaptureDeviceName.AddString( pszOutDebug );

		memset( pszDevName, 0, 20 );		

		OutputDebugString( pszOutDebug );
	}

	for ( ULONG i = 0 ; i < n_audio_device_list_size ; i++ ) {

		sprintf_s( pszHexString, "%llX", p_audio_device_list[ i ]  );

		strDeviceName = pszHexString;

		str1= strDeviceName.Left( 4 );         // EX: DC

		str2 = strDeviceName.Mid( 4, 4 );    // EX: 1150

		str3 = strDeviceName.Mid( 10, 6 );    // EX: USB

		// FOR STRING 1
		//
		if ( str1.GetLength() == 4 )
		{
			pszDev = str1;

			for( nIndex = 0 ; nIndex < 4 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}

		// FOR STRING 2
		//
		if ( str2.GetLength() == 4 )
		{
			sprintf_s(  pszASCIIChar, "%s ", str2 );

			strcat_s( pszDevName, 20, pszASCIIChar );
		}

		// FOR STRING 3
		//
		if ( str3.GetLength() == 6 )
		{
			pszDev = str3;

			for( nIndex = 0 ; nIndex < 6 ; nIndex++ )
			{
				 if( nIndex % 2 != 0 )
				 {
					 char res = (char)HexToAscii( szbuf, pszDev[ nIndex ] );

					 sprintf_s(  pszASCIIChar, "%c", HexToAscii( szbuf, pszDev[ nIndex ] ) );

					 strcat_s( pszDevName, 20, pszASCIIChar );
				 }
				 else
				 {	
					  szbuf = pszDev[ nIndex ];
				 }
			}
		}	

		sprintf_s( pszOutDebug, "Audio#%02x , 0x%llX, Device Name : %s, Analog WaveIn \n", i,  p_audio_device_list[ i ],  pszDevName );		

		m_listboxCaptureDeviceName.AddString( pszOutDebug );

		memset( pszDevName, 0, 20 );				

		OutputDebugString( pszOutDebug );
	}

	for ( ULONG i = 0 ; i < n_audio_encoder_device_list_size ; i++ ) {

		sprintf_s( pszOutDebug, "Audio Encoder#%02x = 0x%llX\n", i,  p_audio_encoder_device_list[ i ] );

		OutputDebugString( pszOutDebug );
	}

	OutputDebugString( "AMESDK_SOUNDCARD_ENUMERATION \n" );

	bSuccess = FALSE;

	CHAR * pszSoundCardDevName = NULL;

	while ( TRUE )
	{
		bSuccess = AMESDK_SOUNDCARD_ENUMERATION( &pszSoundCardDevName, TRUE );

		sprintf_s( pszOutDebug, "Sound Card : %s \n", pszSoundCardDevName );

		m_listboxSoundCard.AddString( pszOutDebug );

		OutputDebugString( pszOutDebug );

		if ( !bSuccess ) break;
	}

	bSuccess = FALSE;

	CHAR * pszCameraDevName = NULL;

	while ( TRUE )
	{
		bSuccess = AMESDK_CAMERA_ENUMERATION( &pszCameraDevName, TRUE );

		sprintf_s( pszOutDebug, "Camera : %s \n", pszCameraDevName );

		m_listboxCamera.AddString( pszOutDebug );

		OutputDebugString( pszOutDebug );

		if ( !bSuccess ) break;
	}

	// CDialogEx::OnOK();
}
